# Comma-Separated Values (CSV) Files

## Importing into a Spreadsheet

Some applications, including Microsoft Excel, do not correctly handle newlines
that are present within CSV data fields.

For example, an address may include street information, followed by a newline,
followed by the city and province, followed by a newline, followed by a postal
code. The newlines are used to provide formatting for the field. This form of
data is valid and part of the CSV specification (please see [1] and [2]).

Applications that do not correctly handle newlines treat data that follows a
newline as a new row of data. This leads to unexpected behaviour and errors
when importing CSV files.

One workaround for this limitation is to use software that correctly processes
CSV files.

For example, LibreOffice can be used to import a CSV file that contains newlines
in data fields. The resulting spreadsheet can either be used as is or LibreOffice
can be used to save the file in Microsoft Excel format (e.g. .xls). The file
can then be opened for editing in Microsoft Excel.

In a similar way, Google Docs can be used to import the CSV file. Again, the
resulting spreadsheet may be used as is or Google Docs may be used to save the
file in Microsoft Excel format for editing in Microsoft Excel.


## LibreOffice

LibreOffice may be obtained free of charge for Windows, Mac, and Linux:
https://www.libreoffice.org/

Alternately, Mac users can use NeoOffice, an OpenOffice port for the Mac:
http://www.neooffice.org


## Google Docs

Google Docs require an Internet connection and a Google account:
http://docs.google.com


## Additional Information

[1] http://tools.ietf.org/html/rfc4180

[2] http://en.wikipedia.org/wiki/Comma-separated_values
